
// size
local menu_width = ScrW() - 64;
local menu_height = ScrH() - 64;

// spawnmenu
local SpawnMenu	= AppFramework:NewApplication( "VMF-Suite, Spawn Menu" );
SpawnMenu:SetPos( 32, 32 );
SpawnMenu:SetSize( menu_width, menu_height );
SpawnMenu:SetCaption( "VMF-Suite - Spawn Menu" );
SpawnMenu:SetIcon( "vgui/TitleBarIcon" );
SpawnMenu:SetAttrb( false, false, false, true, true );
SpawnMenu:Hide();


// populate menu from disk
function SpawnMenu:PopulateMenuFromDirectory( root, dir )
	// setup data
	root.data = root.data or {};
	
	// find files
	local files = file.Find( "../" .. dir .. "/*.*" );
	
	// sort function
	local sortfunc = function( a, b )
				if( ( a.data && a.data.isdir ) && ( b.data && b.data.isdir ) ) then return a:GetText() < b:GetText(); end
				if( a.data && a.data.isdir ) then return true; end
				if( b.data && b.data.isdir ) then return false; end
				
				return a:GetText() < b:GetText();
			end;
	
	// populate.
	local filename;
	for _, filename in pairs( files ) do
		// generate node data.
		local tab = string.Explode( "/", dir .. "/" .. filename );
		local data = {
			isdir = string.find( tab[ table.getn( tab ) ], "%." ) == nil,
			filename = dir .. "/" .. filename,
			state = VMF_FLAG_NONE,
			islocal = true,
			received = false,
			
		};
		
		// calculate path.
		if( data.isdir ) then
			data.path = dir .. "/" .. filename;
			
		else
			data.path = table.concat( tab, "/", 1, table.getn( tab ) - 1 );
			
		end
		
		// create node.
		local node = root:CreateNode();
		node:SetText( tab[ table.getn( tab ) ] );
		if( data.isdir ) then
			node:SetForceExpandable( true );
			node:SetImages( 1, 1 );
			
		else
			node:SetImages( data.state, data.state );
			
		end
		node.data = data;
		
	end
	
	// set to received.
	root.data.received = true;
	
	// sort.
	table.sort( root.Children, sortfunc );

end

// regenerate
function SpawnMenu:RegenerateMyContraptions( )
	// remove the nodes children.
	local root = self.treeview:GetNode( 2 );
	root:RemoveChildren();
	
	// find all directories inside root.
	self:PopulateMenuFromDirectory( root, "vmf/client" );
	
	
	// resize.
	self.treeview:GetHandle():InvalidateLayout();
	
end

	

// init spawn menu
function SpawnMenu:Init( )
	// vars
	self.RefreshList = {
	};
	
	
	// create options items
	local item_orientation = self.listbox:CreateItem();
	item_orientation:SetText( "Orientation" );
	item_orientation:SetImages( 1, 1 );
	item_orientation.index = 1;
	self.panels[1].item = item_orientation;
	
	local item_help = self.listbox:CreateItem();
	item_help:SetText( "Help" );
	item_help:SetImages( 2, 2 );
	item_help.index = 2;
	self.panels[2].item = item_help;
	
	local item_clientsettings = self.listbox:CreateItem();
	item_clientsettings:SetText( "Client Settings" );
	item_clientsettings:SetImages( 3, 3 );
	item_clientsettings.index = 3;
	self.panels[3].item = item_clientsettings;
	
	local item_users = self.listbox:CreateItem();
	item_users:SetText( "Users" );
	item_users:SetImages( 4, 4 );
	item_users.index = 4;
	
	local item_settings = self.listbox:CreateItem();
	item_settings:SetText( "VMF-Suite Settings" );
	item_settings:SetImages( 5, 5 );
	item_settings.index = 5;
	
	// select defailt
	self.listbox:SetSelectedItem( item_orientation );

	
	
	// create root server contraptions node.
	local serverroot = self.treeview:CreateNode();
	serverroot:SetText( "Contraptions" );
	serverroot:SetImages( 1, 1 );
	
	// construct client contraptions.
	local clientroot = self.treeview:CreateNode();
	clientroot:SetText( "My Contraptions" );
	clientroot:SetImages( 1, 1 );
	
	
	// regenerate my contraptions.
	self:RegenerateMyContraptions();
	
	
	
	
end

// create controls
function SpawnMenu:CreateControls( )
	// imagelist.
	local imglist1 = CtlImageList_class:create();
	imglist1:Add( "icons/silk/16/folder" );
	imglist1:Add( "icons/silk/16/page" );
	imglist1:Add( "icons/silk/16/folder_go" );
	imglist1:Add( "icons/silk/16/page_key" );
	imglist1:Add( "icons/silk/16/page_error" );
	imglist1:Add( "icons/silk/16/page_delete" );
	imglist1:Add( "icons/silk/16/page_go" );
	imglist1:Add( "icons/silk/16/page_gear" );
	
	// imagelist
	local imglist2 = CtlImageList_class:create();
	imglist2:Add( "icons/silk/16/orientation" );
	imglist2:Add( "icons/silk/16/help" );
	imglist2:Add( "icons/silk/16/settings" );
	imglist2:Add( "icons/silk/16/group_gear" );
	imglist2:Add( "icons/silk/16/page_gear" );
	
	// create expander button.
	local expander = CtlExpandButton_class:create( self:GetHandle() );
	expander:SetPos( menu_width - 56, 4 );
	expander:SetSize( 32, 24 );
	expander:AddEvent( "OnExpanded", "OnExpanded", self );
	
	
	// create the options listbox.
	local list1 = CtlListBox_class:create( self:GetHandle() );
	list1:SetPos( 32 + ( menu_width * 0.5 - 64 ), 40 );
	list1:SetSize( menu_width * 0.2, menu_height - 80 );
	list1:SetImageList( imglist2 );
	list1:AddEvent( "OnItemSelected", "OnOptionItemSelected", self );
	
	
	// Orientation panel.
	//////////////////////////////////////////////////////////////////////
	local panel1 = CtlOrientationPanel_class:create( self:GetHandle() );
	panel1:SetPos( 32 + ( menu_width * 0.7 - 64 ), 40 );
	panel1:SetSize( menu_width * 0.3, menu_height - 80 );
	//////////////////////////////////////////////////////////////////////
	
	// Help panel.
	//////////////////////////////////////////////////////////////////////
	local panel2 = CtlHTML_class:create( self:GetHandle() );
	panel2:SetPos( 34 + ( menu_width * 0.7 - 64 ), 42 );
	panel2:SetSize( menu_width * 0.3 - 4, menu_height - 82 );
	panel2:Hide( );
	panel2:SetHTML( "N/A" );
	panel2:AddEvent( "OnOpeningURL", "OnOpeningURL", self );
	//////////////////////////////////////////////////////////////////////
	
	// Orientation panel.
	//////////////////////////////////////////////////////////////////////
	local panel3 = CtlClientSettingsPanel_class:create( self:GetHandle() );
	panel3:SetPos( 32 + ( menu_width * 0.7 - 64 ), 40 );
	panel3:SetSize( menu_width * 0.3, menu_height - 80 );
	panel3:Hide();
	//////////////////////////////////////////////////////////////////////
	
	// Users panel.
	//////////////////////////////////////////////////////////////////////
	local panel4 = CtlUserEditor_class:create( self:GetHandle() );
	panel4:SetPos( 32 + ( menu_width * 0.7 - 64 ), 40 );
	panel4:SetSize( menu_width * 0.3, menu_height - 80 );
	panel4:Hide();
	//////////////////////////////////////////////////////////////////////
	
	// VMFSuite Settings
	//////////////////////////////////////////////////////////////////////
	local panel5 = CtlSettingsPanel_class:create( self:GetHandle() );
	panel5:SetPos( 32 + ( menu_width * 0.7 - 64 ), 40 );
	panel5:SetSize( menu_width * 0.3, menu_height - 80 );
	panel5:Hide();
	//////////////////////////////////////////////////////////////////////

	
	// create a treeview.
	local tree1 = CtlTreeview_class:create( self:GetHandle() );
	tree1:SetImageList( imglist1 );
	tree1:SetPos( 32, 40 );
	tree1:SetSize( menu_width * 0.5 - 64, menu_height - 80 ); // 80
	tree1:AddEvent( "OnNodeExpanded", "OnNodeExpanded", self );
	tree1:AddEvent( "OnNodeClicked", "OnNodeClicked", self );

	// Status bar
	local label1 = CtlLabel_class:create( self:GetHandle() );
	label1:SetPos( 32, menu_height - 24 );
	label1:SetSize( menu_width - 64, 16 );
	label1:SetText( "" );
	
	
	// VMF Context Menu.
	//////////////////////////////////////////////////////////////////////
	local vmf_context_root = CtlContextMenu_class:create();
	vmf_context_root:SetImageList( imglist1 );
	vmf_context_root:Hide();
	vmf_context_root:AddEvent( "OnContextItemClick", "OnContextItemClick", self );
	
	// spawn contraption item.
	local spawn_contraption_item = vmf_context_root:CreateItem();
	spawn_contraption_item:SetText( "Spawn Contraption" );
	spawn_contraption_item:SetIcon( 7 );
	spawn_contraption_item.Id = 1;
	
	// spawn contraption w/ gizmo.
	local spawn_contraption_gizmo_item = vmf_context_root:CreateItem();
	spawn_contraption_gizmo_item:SetText( "Spawn Contraption w/ Gizmo" );
	spawn_contraption_gizmo_item.Id = 2;

	// insert a seperator.
	local sep1 = vmf_context_root:CreateItem();
	sep1.Seperator = true;
	
	// create VMF Flags submenu.
	local vmf_flags_submenu = CtlContextMenu_class:create();
	vmf_flags_submenu:SetImageList( imglist1 );
	vmf_flags_submenu:Hide();
	
	// add flags
	local potentially_hazardous = vmf_flags_submenu:CreateItem();
	potentially_hazardous:SetText( "Warning" );
	potentially_hazardous:SetIcon( 5 );
	potentially_hazardous.Flag = VMF_FLAG_WARNING;
	potentially_hazardous.Id = 3;
	
	
	local super_admin = vmf_flags_submenu:CreateItem();
	super_admin:SetText( "Super Admin" );
	super_admin:SetIcon( 6 );
	super_admin.Flag = VMF_FLAG_SUPERADMIN;
	super_admin.Id = 3;
	
	local admin = vmf_flags_submenu:CreateItem();
	admin:SetText( "Admin" );
	admin:SetIcon( 4 );
	admin.Flag = VMF_FLAG_ADMIN;
	admin.Id = 3;
	
	// create submenu entry for VMF flags.
	local vmf_flags_item = vmf_context_root:CreateItem();
	vmf_flags_item:SetText( "Flags" );
	vmf_flags_item:SetSubMenu( vmf_flags_submenu );
	
	// set vmf limits
	local vmf_set_limits = vmf_context_root:CreateItem();
	vmf_set_limits:SetText( "Limits" );
	vmf_set_limits:SetIcon( 8 );
	vmf_set_limits.Id = 6;

	//////////////////////////////////////////////////////////////////////
	
	// VMF Folder Context Menu
	//////////////////////////////////////////////////////////////////////
	local vmf_folder_context_root = CtlContextMenu_class:create();
	vmf_folder_context_root:SetImageList( imglist1 );
	vmf_folder_context_root:Hide();
	vmf_folder_context_root:AddEvent( "OnContextItemClick", "OnContextItemClick", self );
	
	// spawn contraption item.
	local refresh_folder = vmf_folder_context_root:CreateItem();
	refresh_folder:SetText( "Refresh" );
	refresh_folder:SetIcon( 3 );
	refresh_folder.Id = "RefreshFolder";
	//////////////////////////////////////////////////////////////////////
	

	// store
	self.treeview = tree1;
	self.listbox = list1;
	self.status = label1;
	self.expander = expander;
	self.vmf_context_root = vmf_context_root;
	self.vmf_folder_context_root = vmf_folder_context_root;
	
	
	// panels
	self.panels = {
		[1] = panel1,
		[2] = panel2,
		[3] = panel3,
		[4] = panel4,
		[5] = panel5,
	};
	
end


// add events
SpawnMenu:AddEvent( "OnShow", "OnShow" );
SpawnMenu:AddEvent( "OnHide", "OnHide" );

// init controls.
SpawnMenu:CreateControls();
SpawnMenu:Init();


// shrink to context menu
function SpawnMenu:OnExpanded( v )
	// show only context
	if( v ) then
		// shrink the menu width.
		self:SetPos( ScrW() - ( menu_width * 0.3 + 96 ), 32 );
		self:SetSize( menu_width * 0.3 + 64, menu_height );
		
		// move the expander.
		self.expander:SetPos( ( menu_width * 0.3 + 64 ) - 56, 4 );
	
		
		// hide the treeview and listbox.
		self.treeview:Hide();
		self.listbox:Hide();
		self.status:Hide();
		
		// move all of the context panels to the left.
		local i;
		for i = 1, table.getn( self.panels ) do
			self.panels[i]:SetPos( 32, 40 );
		
		end
	
	// show whole thing.
	else
		// grow to full size again.
		self:SetPos( 32, 32 );
		self:SetSize( menu_width, menu_height );
		
		// move expander.
		self.expander:SetPos( menu_width - 56, 4 );
		
		// hide the treeview and listbox.
		self.treeview:Show();
		self.listbox:Show();
		self.status:Show();
		
		// move tree
		self.treeview:SetPos( 32, 40 );
		self.status:SetPos( 32, menu_height - 24 );
		self.listbox:SetPos( 32 + ( menu_width * 0.5 - 64 ), 40 );
		
		// move all of the context panels to the left.
		local i;
		for i = 1, table.getn( self.panels ) do
			self.panels[i]:SetPos( 32 + ( menu_width * 0.7 - 64 ), 40 );
		
		end

	
	end

end



// interaction functions
function SpawnMenu:SetStatus( txt )
	// set status
	self.status:SetText( txt );

end


// panel init
function SpawnMenu:PanelInit( index, panel )
	// help?
	if( index == 2 ) then
		//
		panel:OpenURL( "http://cdbarrett.com/vmfsuitehelp" );
	
	end
	
	// have an attached item?
	if( panel.item ) then
		self.listbox:SetSelectedItem( panel.item );
	
	end

end

// show panel
function SpawnMenu:ShowPanel( index )
	// valid panel?
	if( index == nil || !self.panels[index] ) then
		surface.PlaySound( "buttons/button8.wav" );
		return;
		
	end
	
	// hide all panels.
	local i;
	for i = 1, table.getn( self.panels ) do
		self.panels[i]:Hide();
		
	end
	
	// show the panel.
	self.panels[index]:Show();
	
	
	// call panel init.
	self:PanelInit( index, self.panels[index] );
	
end




// events
function SpawnMenu:OnShow( )
	// enable mouse.
	gui.EnableScreenClicker( true );
	
end

function SpawnMenu:OnHide( )
	// disable mouse.
	gui.EnableScreenClicker( false );
	
end

function SpawnMenu:OnContextItemClick( item )
	// get node.
	local node = self.treeview:GetSelectedNode();
	if( !node || !node.data ) then return; end

	// play sound so they know.
	surface.PlaySound( "buttons/button9.wav" );
		
	// spawn.
	if( item.Id == 1 ) then
		LocalPlayer():ConCommand( "VMF_Load " .. node.data.filename .. "\n" );
		
		// change icon
		node:SetImages( 7, 7 );
		timer.Simple( 0.75, node.SetImages, node, node.data.state, node.data.state );
		

	// spawn w/ gizmo
	elseif( item.Id == 2 ) then
	
		// change icon
		node:SetImages( 7, 7 );
		timer.Simple( 0.75, node.SetImages, node, node.data.state, node.data.state );
	
	// flags
	elseif( item.Id == 3 ) then
		LocalPlayer():ConCommand( "vmfsuite_flag \"" .. node.data.filename .. "\" " .. item.Flag .. "\n" );
		
		// TODO: Do this on the server and update all clients instead of this one.
		node.data.state = item.Flag;
		node:SetImages( node.data.state, node.data.state );
		
		// color it.
		if( VMF_FLAG_COLORS[ node.data.state ] ) then
			node:SetTextColor( VMF_FLAG_COLORS[ node.data.state ] );
			
		end
		
	end

	// refresh
	if( item.Id == "RefreshFolder" ) then
		self:SendListRequest( node );
		
	end

end

function SpawnMenu:OnOpeningURL( url, target )
	// is it one of ours?
	local cmdstring = string.gsub( url, "vmf://", "" );
	
	// split
	local command = string.Explode( "/", cmdstring );
	if( table.getn( command ) < 1 ) then return; end
	
	// check command
	if( command[1] == "showpanel" ) then
		// show panel.
		self:ShowPanel( tonumber( command[2] ) );
	
	// set rotation.
	elseif( command[1] == "rotate" ) then
		// rotate the vmf.
		LocalPlayer():ConCommand( "vmf_rotation_" .. ( command[2] or "y" ) .. " " .. ( command[3] or "0" ) .. "\n" );
		
	// set translation.
	elseif( command[1] == "translate" ) then
		// translate the vmf.
		LocalPlayer():ConCommand( "vmf_offset_" .. ( command[2] or "z" ) .. " " .. ( command[3] or "0" ) .. "\n" );
		
	// 
	
	end
	

end

function SpawnMenu:OnOptionItemSelected( item )
	// show
	self:ShowPanel( item.index );
	
end

function SpawnMenu:OnInitProgressBar( msg )
	// init bar.
	local mins, maxs = msg:ReadShort(), msg:ReadShort();
	self.progressbar:SetRange( mins, maxs );
	
end

function SpawnMenu:OnUpdateProgressBar( msg )
	// set value
	self.progressbar:SetValue( msg:ReadShort() );
	
end

function SpawnMenu:OnClearProgressBar( msg )
	// clear it
	self.progressbar:SetValue( 0 );
	
end

function SpawnMenu:OnNodeClicked( node, mc )
	// load?
	if( node.data && !node.data.isdir && mc == MOUSE_LEFT ) then
		// LOAD.
		if(node.data.filename) then
			LocalPlayer():ConCommand( "VMF_Load " .. node.data.filename .. "\n" );
		end
		// play sound so they know.
		surface.PlaySound( "buttons/button9.wav" );
		
		// change icon
		node:SetImages( 7, 7 );
		timer.Simple( 0.75, node.SetImages, node, node.data.state, node.data.state );

	// right? file?
	elseif( mc == MOUSE_RIGHT && node.data && !node.data.isdir ) then
		self.vmf_context_root:Popup();
		
	// right? folder?
	elseif( mc == MOUSE_RIGHT && node.data && node.data.isdir ) then
		self.vmf_folder_context_root:Popup();
	
	end
	
end

function SpawnMenu:OnNodeExpanded( node )
	// should we request a node list?
	if( node.data && node.data.isdir && !node.data.received && !node.data.busy ) then
		// request list from server.
		if( !node.data.islocal ) then
			// send request to server.
			self:SendListRequest( node );
		
			// don't allow them to expand it.
			return true;
		
		// populate and open it.	
		else
			//
			self:PopulateMenuFromDirectory( node, node.data.path );
			print( node.data.path );
			
		end
		
	end

end

function SpawnMenu:OnListReceived( msg )
	// read message.
	local id = msg:ReadShort();
	local more = msg:ReadBool();
	local state = msg:ReadShort();
	local filename = string.gsub( msg:ReadString(), "\\", "/" );
	
	// do we have a request that uses this id?
	local itr_key, request, request_key;
	for itr_key, itr in pairs( self.RefreshList ) do
		if( itr.id == id ) then
			// store and break.
			request = itr;
			request_key = itr_key;
			break;
			
		end
		
	end
		
	// generate node data.
	local tab = string.Explode( "/", filename );
	local data = {
		received = false,
		isdir = string.find( tab[ table.getn( tab ) ], "%." ) == nil,
		filename = filename,
		state = state,
		islocal = false,
		
	};
	
	// calculate path.
	if( data.isdir ) then
		data.path = filename;
	else
		data.path = table.concat( tab, "/", 1, table.getn( tab ) - 1 );
	end
	
	// sort function
	local sortfunc = function( a, b )
				if( ( a.data && a.data.isdir ) && ( b.data && b.data.isdir ) ) then return a:GetText() < b:GetText(); end
				if( a.data && a.data.isdir ) then return true; end
				if( b.data && b.data.isdir ) then return false; end
				
				return a:GetText() < b:GetText();
			end;
	
	
	// found one?
	if( request ) then
		// add.
		request.count = request.count + 1;
		
		// update status.
		self:SetStatus( "Received directory listing [" .. tab[ table.getn( tab ) ] .. "]" );
		
		// create node.
		local node = request.node:CreateNode();
		node:SetText( tab[ table.getn( tab ) ] );
		if( data.isdir ) then
			node:SetForceExpandable( true );
			node:SetImages( 1, 1 );
			
		else
			node:SetImages( data.state, data.state );
			
		end
		node.data = data;
		
		// color it.
		if( VMF_FLAG_COLORS[ data.state ] ) then
			node:SetTextColor( VMF_FLAG_COLORS[ data.state ] );
			
		end
		
		// sort.
		table.sort( request.node.Children, sortfunc );
		
		// no more coming?
		if( !more ) then
			// flag this as received.
			request.node.data.received = true;
			request.node.data.busy = false;
			
			// expand the node.
			request.node:SetExpanded( true );
			
			// restore the folder image
			request.node:SetImages( 1, 1 );
			
			// status
			self:SetStatus( "Listing received [ Total: " .. request.count .. " ]" );
			
			// remove the request
			table.remove( self.RefreshList, request_key );
				
		end
	
		
	// add to the server contraptions main list.
	else
		// find the node
		local root = self.treeview:GetNode( 1 );
		if( root ) then
			// add
			local node = root:CreateNode();
			node:SetText( tab[ table.getn( tab ) ] );
			if( data.isdir ) then
				node:SetForceExpandable( true );
				node:SetImages( 1, 1 );
				
			else
				node:SetImages( data.state, data.state );
				
			end
			node.data = data;
			
			// color it.
			if( VMF_FLAG_COLORS[ data.state ] ) then
				node:SetTextColor( VMF_FLAG_COLORS[ data.state ] );
				
			end
			
			// sort.
			table.sort( root.Children, sortfunc );
		
		end
	
	end
	
end




// methods
function SpawnMenu:SendListRequest( node )
	// read the node path.
	local path = node.data.path;
	
	// flag the node as busy so we won't get a stack overflow.
	node.data.busy = true;
	
	// generate a request.
	local request = {
		count = 0,
		node = node,
		id = math.random( 1, 16384 ),
	};
	table.insert( self.RefreshList, request );
	
	// update status.
	self:SetStatus( "Requesting directory listing [" .. path .. "]" );
	
	// request it.
	LocalPlayer():ConCommand( "VMF_RequestList " .. request.id .. " " .. path .. "\n" );
	
	// just a little gui glitter.
	node:SetImages( 3, 3 );
	
	
	// shrink the node
	node:SetExpanded( false );
	
	// remove it's children
	node:RemoveChildren();
	
end




// our spawn menu utilizes usermessages and a hook.
local CSpawnMenu =	OOP_Derive( CUserMessage, CHook );

// constructor
function CSpawnMenu:__ctor( )
	// hook events
	self:HookEvent( "PlayerBindPress" );
	
	// hook message
	self:HookMessage( "VMFList" );

end

// vmf listing
function CSpawnMenu:OnVMFList( msg )
	// pass along to the spawnmenu.
	SpawnMenu:OnListReceived( msg );	

end

// bind pressed
function CSpawnMenu:OnPlayerBindPress( pl, bind, pressed )
	// convar string
	local toolmode = GetConVarString( "gmod_toolmode" ) or "";
	if( string.lower( toolmode ) == "spawn_tool" ) then
		// check bind.
		if( bind == "+menu_context" && pressed ) then
			// show
			SpawnMenu:Show();
			return true;
			
		elseif( bind == "+menu_context" && !pressed ) then
			// hide.
			SpawnMenu:Hide();
			return true;
			
		end
	end
	
end

// create spawnmenu object
local spawnmenu = CSpawnMenu:create();





// Client settings.
	//////////////////////////////////////////////////////////////////////
	/*
	// access flags.
	local header = CtlHeader_class:create( panel3:GetHandle() );
	header:SetPos( 4, 4 );
	header:SetSize( menu_width * 0.3 - 8, 32 );
	header:SetTitle( "Access Flags" );
	
	local body = CtlBody_class:create( panel3:GetHandle() );
	body:SetPos( 4, 38 );
	body:SetSize( menu_width * 0.3 - 8, 120 );
	
	// create checkboxes.
	local i;
	local y, column = 0, 0;
	local checkboxes = {};
	local halfwidth = ( menu_width * 0.3 ) * 0.5;
	local quaterwidth = ( menu_width * 0.3 ) * 0.25;
	for i = 97, 122 do
		// create checkboxes.
		local checkbox = CtlCheckBox_class:create( body:GetHandle() );
		checkbox:SetPos( 4 + ( quaterwidth * column ), 4 + y );
		checkbox:SetSize( halfwidth - 8, 16 );
		checkbox:SetText( string.char( i ) );
		
		// insert
		checkboxes[ string.char( i ) ] = checkbox;
		
		// increment.
		y = y + 16;
		
		// increment column.
		if( ( y / 16 ) > 6 ) then
			y = 0;
			column = column + 1;
		
		end
		
	end
	
	// flags.
	local header = CtlHeader_class:create( panel3:GetHandle() );
	header:SetPos( 4, 162 );
	header:SetSize( menu_width * 0.3 - 8, 32 );
	header:SetTitle( "Flags" );
	
	local body = CtlBody_class:create( panel3:GetHandle() );
	body:SetPos( 4, 196 );
	body:SetSize( menu_width * 0.3 - 8, 120 );
	
	
	// listbox.
	local flagslist = CtlListBox_class:create( body:GetHandle() );
	flagslist:SetPos( 4, 4 );
	flagslist:SetSize( ( menu_width * 0.3 ) - 16, 112 );
	flagslist:SetImageList( imglist1 );
	
	// items.
	local superadmin = flagslist:CreateItem();
	superadmin:SetText( "Super Admin" );
	superadmin:SetImages( 6, 6 );
	superadmin.Flag = VMF_FLAG_SUPERADMIN;
	
	local admin = flagslist:CreateItem();
	admin:SetText( "Admin" );
	admin:SetImages( 4, 4 );
	admin.Flag = VMF_FLAG_ADMIN;
	
	local warning = flagslist:CreateItem();
	warning:SetText( "Warning" );
	warning:SetImages( 5, 5 );
	warning.Flag = VMF_FLAG_WARNING;
	
	*/
	
	//////////////////////////////////////////////////////////////////////